<?php
require_once __DIR__ . '/../config/db.php';

try {
    // Add 'refund' to the source_type ENUM in product_serial_numbers table
    $pdo->exec("ALTER TABLE product_serial_numbers MODIFY COLUMN source_type ENUM('manual_adjustment', 'supplier_receipt', 'refund') NOT NULL");
    echo "Successfully added 'refund' to source_type ENUM in product_serial_numbers table.\n";
    
    // Verify the change
    $stmt = $pdo->query("DESCRIBE product_serial_numbers");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($columns as $column) {
        if ($column['Field'] === 'source_type') {
            echo "Updated source_type column: " . $column['Type'] . "\n";
            break;
        }
    }
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
} 